/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2019 NXP
 * All rights reserved.
 * 
 * SPDX-License-Identifier: BSD-3-Clause
 */
#include "board.h"
#include "fsl_debug_console.h"
#include "fsl_dma.h"

#include "pin_mux.h"
#include <stdbool.h>

#include "fsl_iocon.h"
#include "pin_mux.h"
#include "fsl_pint.h"
#include "fsl_inputmux_connections.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

#define BUFF_LENGTH 4U

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/
dma_handle_t g_DMA_Handle;
volatile bool g_Transfer_Done = false;

/*******************************************************************************
 * Code
 ******************************************************************************/

/* User callback function for DMA transfer. */
/** Peripheral USART0 base address */
#define USART0_BASE_NS                           (0x40086000u)
/** Peripheral USART0 base pointer */
#define USART0_NS                                ((USART_Type *)USART0_BASE_NS)
volatile USART_Type *USART0_NS_Base = (USART_Type *)USART0_NS;
  
 
#define INPUTMUX_BASE                            (0x50006000u)
/** Peripheral INPUTMUX base address */
#define INPUTMUX_BASE_NS                         (0x40006000u)
/** Peripheral INPUTMUX base pointer */
#define INPUTMUX                                 ((INPUTMUX_Type *)INPUTMUX_BASE)
/** Peripheral INPUTMUX base pointer */
#define INPUTMUX_NS                              ((INPUTMUX_Type *)INPUTMUX_BASE_NS)
  volatile INPUTMUX_Type *INPUTMUX_NS_Base = (INPUTMUX_Type *)INPUTMUX_NS;  
volatile INPUTMUX_Type *INPUTMUX_Base = (INPUTMUX_Type *)INPUTMUX;  
  
/** Peripheral DMA0 base address */
#define DMA0_BASE_NS                             (0x40082000u)
/** Peripheral DMA0 base pointer */
#define DMA0_NS                                  ((DMA_Type *)DMA0_BASE_NS)
volatile DMA_Type *DMA0_NS_Base = (DMA_Type *)DMA0_NS;    
  
  
  
void DMA_Callback(dma_handle_t *handle, void *param, bool transferDone, uint32_t tcds)
{
    if (transferDone)
    {
        g_Transfer_Done = true;
    }
}

/* PINT2 */
#define DEMO_PINT_PIN_INT2_SRC kINPUTMUX_GpioPort1Pin9ToPintsel
void pint_intr_callback(pint_pin_int_t pintr, uint32_t pmatch_status)
{
//    PRINTF("\f\r\nPINT Pin Interrupt %d event detected.", pintr);
}

static uint32_t APP_Get_DMA_Mode_Selection(void)
{
    uint32_t ch;

    while (1)
    {
        ch = GETCHAR();
        if ((ch < '1') || (ch > '4')) /* Only '1', '2', '3' , '4'.*/
        {
            continue;
        }
        else
        {
            ch = ch - '0';
            break;
        }   
    } 
    return ch;
}
const char *g_DMA_Mode_InfoStr[] = {"0.Nothing",
                                    "1.M2M (Note: Do not need other operation)", 
                                    "2.M2P (Note: User need press Button_'S3_USER' to Trigger DMA)",
                                    "3.M2P (Note: Do not need other operation)", 
                                    "4.P2M (Note: User need Input a character)"};
uint32_t gCurrent_DMA_Mode;


int main(void)
{
    uint32_t srcAddr[BUFF_LENGTH] = {'1', '2', '3', '4'};
    uint32_t desAddr[BUFF_LENGTH] = {'0', '0', '0', '0'};
    uint32_t i = 0 , j=0;
    dma_transfer_config_t transferConfig;

    /* attach 12 MHz clock to FLEXCOMM0 (debug console) */
    CLOCK_AttachClk(kFRO12M_to_FLEXCOMM0);

    BOARD_InitPins();
    BOARD_BootClockFROHF96M();
    BOARD_InitDebugConsole();
    PRINTF(
        "\r\n\r\nSelect a DMA transfer mode \r\n"
        "\t1. Memory to Memory(Software Trigger)\r\n"
        "\t2. Memory to Peripheral(Hardware Trigger)\r\n"
        "\t3. Memory to Peripheral(Software Trigger)\r\n"
        "\t4. Peripheral to Memory(Software Trigger) \r\n");
		while(1)
		{
				gCurrent_DMA_Mode = APP_Get_DMA_Mode_Selection();
				PRINTF("\r\nEntering %s ...\r\n", g_DMA_Mode_InfoStr[gCurrent_DMA_Mode]);

						/* Enter the DMA Transfer mode. */
						switch (gCurrent_DMA_Mode)
						{ 
							case 1:
									/* Print source buffer */
									PRINTF("desAddr[] Buffer:\r\n");
									for (i = 0; i < BUFF_LENGTH; i++)
									{
											PRINTF("%c\t", desAddr[i]);
									}
									/* Configure DMA one shot transfer */
									/*
									 * userConfig.enableRoundRobinArbitration = false;
									 * userConfig.enableHaltOnError = true;
									 * userConfig.enableContinuousLinkMode = false;
									 * userConfig.enableDebugMode = false;
									 */
									DMA_Init(DMA0);
									DMA_CreateHandle(&g_DMA_Handle, DMA0, 5);
									DMA_EnableChannel(DMA0, 5);
									DMA_SetCallback(&g_DMA_Handle, DMA_Callback, NULL);
									DMA_PrepareTransfer(&transferConfig, srcAddr, desAddr, sizeof(srcAddr[0]), sizeof(srcAddr), kDMA_MemoryToMemory,
																			NULL);        
									DMA_SubmitTransfer(&g_DMA_Handle, &transferConfig);
									DMA_StartTransfer(&g_DMA_Handle);
									/* Wait for DMA transfer finish */
									while (g_Transfer_Done != true)
									{
									}
									/* Print destination buffer */
									PRINTF("\r\ndesAddr[] Buffer:\r\n");
									for (i = 0; i < BUFF_LENGTH; i++)
									{
											PRINTF("%c\t", desAddr[i]);
									}           
									PRINTF("\r\n\DMA Memory to Memory(Software Trigger) example finish, pressing 'S4_RESET' to verify other DMA transfer.\r\n");
							break;  
							
							case 2:

									/* Connect trigger sources to PINT */
									INPUTMUX_Init(INPUTMUX);
									INPUTMUX_AttachSignal(INPUTMUX, kPINT_PinInt2, DEMO_PINT_PIN_INT2_SRC);
									/* Initialize PINT */
									PINT_Init(PINT);
									/* Setup Pin Interrupt 2 for falling edge */
									PINT_PinInterruptConfig(PINT, kPINT_PinInt2, kPINT_PinIntEnableFallEdge, pint_intr_callback);
									/* Enable callbacks for PINT2 by Index */
									PINT_EnableCallbackByIndex(PINT, kPINT_PinInt2);    

									DMA_Init(DMA0);
									DMA_CreateHandle(&g_DMA_Handle, DMA0, 5);
									DMA_EnableChannel(DMA0, 5);
									DMA_SetCallback(&g_DMA_Handle, DMA_Callback, NULL);

									DMA_PrepareTransfer(&transferConfig, srcAddr, (void *)(&USART0_NS_Base->FIFOWR), sizeof(srcAddr[0]), sizeof(srcAddr), kDMA_MemoryToPeripheral,
																			NULL); 
									
									DMA_SubmitTransfer(&g_DMA_Handle, &transferConfig);
							//    DMA_StartTransfer(&g_DMA_Handle);
									DMA_EnableChannel(DMA0, 5);/* enable channel */
									
							//--Should configure CFG
									DMA0_NS_Base->CHANNEL[5].CFG |= DMA_CHANNEL_CFG_HWTRIGEN_MASK | DMA_CHANNEL_CFG_PERIPHREQEN_MASK;
									DMA0_NS_Base->CHANNEL[5].XFERCFG &= ~DMA_CHANNEL_XFERCFG_SWTRIG_MASK;           
									INPUTMUX_Base->DMA0_ITRIG_INMUX[5] = 0x2;                         
										 
									/* Wait for DMA transfer finish */
									while (g_Transfer_Done != true)
									{
									}

									/* Print destination buffer */
									PRINTF("\r\nDMA Memory to Peripheral(Hardware Trigger) example finish, pressing 'S4_RESET' to verify other DMA transfer.\r\n\r\n");
									DMA_Deinit(DMA0);
								break;
								
							case 3:
									DMA_Init(DMA0);
									DMA_CreateHandle(&g_DMA_Handle, DMA0, 5);
									DMA_EnableChannel(DMA0, 5);
									DMA_SetCallback(&g_DMA_Handle, DMA_Callback, NULL);
									DMA_PrepareTransfer(&transferConfig, srcAddr, (void *)(&USART0_NS_Base->FIFOWR), sizeof(srcAddr[0]), sizeof(srcAddr), kDMA_MemoryToPeripheral,  //--FIFOWR
																			NULL);        
									DMA_SubmitTransfer(&g_DMA_Handle, &transferConfig);
									DMA_StartTransfer(&g_DMA_Handle);
									/* Wait for DMA transfer finish */
									while (g_Transfer_Done != true)
									{
									}
									/* Print destination buffer */
									PRINTF("\r\nDMA Memory to Peripheral(Software Trigger) example finish, pressing 'S4_RESET' to verify other DMA transfer.\r\n\r\n");
								break;
								DMA_Deinit(DMA0);
							case 4: 
								PRINTF("Input a character for P2M and then read this character from (USART0->FIFOWR(RO)):");           //--Input any character  (DMA will not work if 'FIFORD' is empty!!!)       
								DMA_Init(DMA0);
								DMA_CreateHandle(&g_DMA_Handle, DMA0, 4);
								DMA_EnableChannel(DMA0, 4);
								DMA_SetCallback(&g_DMA_Handle, DMA_Callback, NULL);
								DMA_PrepareTransfer(&transferConfig, (void *)(&USART0_NS_Base->FIFORD),desAddr, 4, 4, kDMA_PeripheralToMemory,           
																		NULL);  //--0x4008 6E30h           
								DMA_SubmitTransfer(&g_DMA_Handle, &transferConfig);
								DMA_StartTransfer(&g_DMA_Handle);
								/* Wait for DMA transfer finish */
								while (g_Transfer_Done != true)
								{
								}

								/* Print destination buffer */
								PRINTF("\r\n desAddr[] Buffer: = %c ",desAddr[0]);
								PRINTF("\r\nDMA Peripheral to Memory(Software Trigger) example finish, pressing 'S4_RESET' to verify other DMA transfer."); 
								break;
								
							default:
								
										break;            
						}
		}
}